/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityColorChange;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.RenderText;

public class GUIPaintGun
extends AGUIBase {
    private final AEntityD_Definable<?> entity;
    private final IWrapperPlayer player;
    private GUIComponentLabel partName;
    private GUIComponentButton prevColorButton;
    private GUIComponentButton nextColorButton;
    private GUIComponentButton nextRecipeButton;
    private GUIComponentButton confirmButton;
    private final List<GUIComponentItem> craftingItemIcons = new ArrayList<GUIComponentItem>();
    private final List<GUIComponentCutout> craftingItemBackgrounds = new ArrayList<GUIComponentCutout>();
    private List<PackMaterialComponent> materials;
    private GUIComponent3DModel modelRender;
    private AItemSubTyped<?> currentItem;
    private AItemSubTyped<?> prevSubItem;
    private AItemSubTyped<?> nextSubItem;
    private int recipeIndex;

    public GUIPaintGun(AEntityD_Definable<?> entity, IWrapperPlayer player) {
        this.entity = entity;
        this.player = player;
        this.currentItem = (AItemSubTyped)PackParser.getItem(((AJSONMultiModelProvider)entity.definition).packID, ((AJSONMultiModelProvider)entity.definition).systemName, entity.subDefinition.subName);
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.prevColorButton = new GUIComponentButton(this, this.guiLeft + 38, this.guiTop + 135, 20, 20, 40, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.prevSubItem;
                GUIPaintGun.this.recipeIndex = 0;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addComponent(this.prevColorButton);
        this.nextColorButton = new GUIComponentButton(this, this.guiLeft + 160, this.guiTop + 135, 20, 20, 60, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPaintGun.this.currentItem = GUIPaintGun.this.nextSubItem;
                GUIPaintGun.this.recipeIndex = 0;
                GUIPaintGun.this.updateNames();
            }
        };
        this.addComponent(this.nextColorButton);
        this.nextRecipeButton = new GUIComponentButton(this, this.guiLeft + 233, this.guiTop + 100, 20, 20, 80, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                if (++GUIPaintGun.this.recipeIndex == ((GUIPaintGun)GUIPaintGun.this).currentItem.subDefinition.extraMaterialLists.size()) {
                    GUIPaintGun.this.recipeIndex = 0;
                }
                GUIPaintGun.this.updateNames();
            }
        };
        this.addComponent(this.nextRecipeButton);
        this.partName = new GUIComponentLabel(this.guiLeft + 60, this.guiTop + 120, ColorRGB.WHITE, "", RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, 98);
        this.addComponent(this.partName);
        this.craftingItemIcons.clear();
        this.craftingItemBackgrounds.clear();
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            GUIComponentItem craftingItem = new GUIComponentItem(this.guiLeft + 225 + 18 * (i / 4), this.guiTop + 26 + 18 * (i % 4), 1.0f);
            GUIComponentCutout itemBackground = new GUIComponentCutout(this, craftingItem.constructedX, craftingItem.constructedY, craftingItem.width, craftingItem.height, 160, 236, 20, 20);
            itemBackground.visible = false;
            this.addComponent(craftingItem);
            this.addComponent(itemBackground);
            this.craftingItemIcons.add(craftingItem);
            this.craftingItemBackgrounds.add(itemBackground);
        }
        this.modelRender = new GUIComponent3DModel(this.guiLeft + 109, this.guiTop + 57, 32.0f, true, true, false);
        this.addComponent(this.modelRender);
        this.confirmButton = new GUIComponentButton(this, this.guiLeft + 99, this.guiTop + 167, 20, 20, 20, 196, 20, 20){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityColorChange(GUIPaintGun.this.entity, GUIPaintGun.this.player, GUIPaintGun.this.currentItem, GUIPaintGun.this.recipeIndex));
                GUIPaintGun.this.close();
            }
        };
        this.addComponent(this.confirmButton);
        this.updateNames();
    }

    @Override
    public void setStates() {
        super.setStates();
        this.prevColorButton.enabled = this.prevSubItem != null;
        this.nextColorButton.enabled = this.nextSubItem != null;
        this.nextRecipeButton.enabled = this.currentItem.subDefinition.extraMaterialLists.size() > 1;
        boolean bl = this.confirmButton.enabled = this.currentItem != null && (this.player.isCreative() || this.materials != null && this.player.getInventory().hasMaterials(this.materials));
        if (this.materials != null) {
            for (int i = 0; i < this.craftingItemIcons.size(); i = (int)((byte)(i + 1))) {
                if (i < this.materials.size()) {
                    this.craftingItemIcons.get((int)i).stacks = this.materials.get((int)i).possibleItems;
                    this.craftingItemBackgrounds.get((int)i).visible = !this.player.isCreative() && GUIPaintGun.inClockPeriod(20, 10) && this.player.getInventory().hasSpecificMaterial(this.currentItem, this.recipeIndex, i, false, true, false, true);
                    continue;
                }
                this.craftingItemIcons.get((int)i).stacks = null;
                this.craftingItemBackgrounds.get((int)i).visible = false;
            }
        } else {
            this.craftingItemIcons.forEach(icon -> {
                icon.stacks = null;
            });
        }
    }

    @Override
    public int getWidth() {
        return 327;
    }

    @Override
    public int getHeight() {
        return 196;
    }

    @Override
    protected String getTexture() {
        return "mts:textures/guis/repainting.png";
    }

    private void updateNames() {
        int i;
        List<AItemPack<?>> packItems = PackParser.getAllItemsForPack(((AJSONMultiModelProvider)this.currentItem.definition).packID, true);
        int currentItemIndex = packItems.indexOf(this.currentItem);
        this.nextSubItem = null;
        if (currentItemIndex < packItems.size()) {
            for (i = currentItemIndex + 1; i < packItems.size() && this.nextSubItem == null; ++i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((AJSONMultiModelProvider)this.currentItem.definition).systemName)) continue;
                this.nextSubItem = (AItemSubTyped)packItems.get(i);
                break;
            }
        }
        this.prevSubItem = null;
        if (currentItemIndex > 0) {
            for (i = currentItemIndex - 1; i >= 0 && this.prevSubItem == null; --i) {
                if (!((AJSONItem)packItems.get((int)i).definition).systemName.equals(((AJSONMultiModelProvider)this.currentItem.definition).systemName)) continue;
                this.prevSubItem = (AItemSubTyped)packItems.get(i);
                break;
            }
        }
        this.partName.text = this.currentItem.getItemName();
        String errorMessage = "";
        do {
            this.materials = PackMaterialComponent.parseFromJSON(this.currentItem, this.recipeIndex, false, true, false, false);
            if (this.materials != null) continue;
            if (++this.recipeIndex >= this.currentItem.subDefinition.extraMaterialLists.size()) {
                this.recipeIndex = 0;
            }
            errorMessage = errorMessage + PackMaterialComponent.lastErrorMessage + "\n";
            if (this.recipeIndex != 0) continue;
            InterfaceManager.coreInterface.logError(errorMessage);
            break;
        } while (this.materials == null);
        this.modelRender.modelLocation = ((AJSONMultiModelProvider)this.currentItem.definition).getModelLocation(this.currentItem.subDefinition);
        this.modelRender.textureLocation = ((AJSONMultiModelProvider)this.currentItem.definition).getTextureLocation(this.currentItem.subDefinition, 0);
    }
}

